define([
    'underscore',
    'backbone',
    'modules/page/popup/popup-view',
    'text!modules/about/about.html',
    'json!versionInfoJson',
], function (_, Backbone, PopupView, template, version) {
    'use strict';

    return PopupView.extend({
        'template': _.template(template),
        'id': 'about',
        'ui': {version: '#version'},
        'initialize': function(options) {
            var versionConfig = version;
            this.appVersion = versionConfig.version;
            if (versionConfig.build) {
                this.appVersion += '.' + versionConfig.build;
            }
            this._initializeElAfterClose(options);
            this.model = new Backbone.Model({
                appVersion: versionConfig.version + (versionConfig.build ? '.' + versionConfig.build : ''),
            });
        },
    });
});
